/**
 * Function validate password
 * @param password1
 * @param password2
 * @return Devuelve true si el password1 y password2 son iguales. False
 * en caso contrario
 */
const COLOR_ERROR = 'red lighten-1';
const COLOR_OK = 'indigo lighten-2';

function validatePassword(msg) {
    var password1 = $('#password1').val();
    var password2 = $('#password2').val();
    if (password1 != password2) {
        Materialize.toast(msg, 5000,COLOR_ERROR);
        password1 = $('#password1').val("");
        password2 = $('#password2').val("");
        return false;
    }
}
/**
 * Lanza el modal para actualizar  un determinado equipo cuyo id es pasado
 * por parametro
 * @param idm Identificador del modal que se quiere abrir
 * @returns {boolean} false para que no se envie el formulario ( Eliminar equipo )
 */
function updateModal(idm) {

    var id = '#updateTeamModal'.concat(idm);
    $(id).modal('open');
    return false;
}
/**
 * Se devuelve false para que no se submitee el formulario y no se
 * elimine al arbitro.
 * @param idm
 * @returns {boolean}
 */
function updateReferee(idm) {

    var id = '#updateRefereeID'.concat(idm);
    $(id).modal('open');
    return false;
}

function update_timekeeper_password(email) {
    $('#update_passwd_timekeeper').modal('open');
    $('#timekeeperid').val(email); // en el modal le pasamos el valor del id del cronometrador, en este caso es el email
    return false;


}
/**
 * Funcion f5 del navegador, reload
 */
function refresh_window() {
        location.reload();

}
/**
 * Peticion ajax para ver la info de los arbitros que pueden arbitarr un determinado combate
 * @param dniW
 * @param dniB
 * @param idCompetition
 * @param idMat
 * @param url
 */
function infoReferees(dniW,dniB,idCompetition,idMat,url) {

    $.ajax({
        type: "POST",
        url: url,
        data: {
            dniW: dniW,
            dniB: dniB,
            idCompetition:idCompetition,
            idMat :idMat
        },
        success: function (result) {
            if(result.length == 0) {
                Materialize.toast('No hay árbitros inscritos en este tatami o es del mismo club que ambos competidores', 2000,'amber');
            }
            for (var i = 0 ; i < result.length; i ++ ) {
                var $toastContent = $('<span>'
                    +'<i class="material-icons left">info</i>'
                    +result[i]['nombreArbitro']
                    + ','
                    + result[i]['apellido1']
                    +'('
                    + result[i]['nombre']
                    +')'
                    + ' </span>'


                );
                Materialize.toast($toastContent, 1500,'indigo');
            }
        },
        dataType:"json",
        error: function (result) {
//                console.log(error);
            Materialize.toast('No fue posible conectarse al servidor en este momento. Inténtalo de nuevo más tarde.',5000,'amber lighten-1');

        }
    })
}
var overlay = document.getElementById("overlay");
// pageloader
window.addEventListener('load', function(){
    overlay.style.display = 'none';
})




